from intranet.search.core.storages.job_storage import JobStorage
from intranet.search.core.management.commands.yql_base import Command as BaseCommand


class Command(BaseCommand):
    help = 'Calculate isearch metrics'
    job_name = 'calc_metrics'
    yql_script_name = 'calc_metrics.yql'
    yql_attachments_files = BaseCommand.yql_attachments_files + ['libra_parse_metrics.py']

    def get_default_date_from(self, date_to):
        last_job = JobStorage().get_last_success(self.job_name)
        return last_job['end_time'].date() if last_job else ''
