from django.db.transaction import atomic

from intranet.search.core.management.commands.yql_base import Command as BaseCommand
from intranet.search.core.models import ClickedMarkedUrl


class Command(BaseCommand):
    help = 'Collect data about clicked and marked urls and queries'
    default_period = 60
    job_name = 'update_clicked_marked_urls'
    yql_script_name = 'get_clicked_or_marked_urls.yql'
    yql_attachments_files = BaseCommand.yql_attachments_files + ['libra_parse_clicks.py']

    def save_data(self, data):
        new_urls = [ClickedMarkedUrl(**item) for item in data]
        with atomic():
            ClickedMarkedUrl.objects.all().delete()
            ClickedMarkedUrl.objects.bulk_create(new_urls)
