from importlib import import_module
from uuid import uuid4

from django.conf import settings
from django.core.management.base import BaseCommand
from ylog.context import log_context

from intranet.search.core.storages import JobStorage


class Command(BaseCommand):
    help = 'Run mapreduce job'

    def add_arguments(self, parser):
        parser.add_argument('job_name', type=str)

        parser.add_argument('--env', action='store',
                            choices=['development', 'testing', 'production'],
                            default=settings.YENV_TYPE,
                            help=("Type of environment. Choices: "
                                  "development, testing, production"))
        parser.add_argument('--start_date', action='store',  default='',
                            help='Start date for searchlog import')
        parser.add_argument('--end_date', action='store', default='',
                            help='End date for searchlog import')

    def handle(self, job_name, **options):
        with log_context(yt_job=job_name, run_id=uuid4().hex):
            try:
                module = import_module('.' + job_name, package='intranet.search.yt.jobs')
            except ImportError:
                print("Unknown job %s\n" % job_name)
                raise

            Job = getattr(module, 'Job', None)
            job_storage = JobStorage()
            jobst_id = job_storage.create(job_name, Job.entity, options)

            if Job is None:
                msg = "Cant find Job class in %s" % module
                job_storage.finish(jobst_id, msg, fail=True)
                raise RuntimeError(msg)

            try:
                job = Job(options)
                job_storage.set_status(jobst_id, 'running')
                job.run()
            except Exception as exc:
                job_storage.finish(jobst_id, str(exc), fail=True)
                raise
            except:
                job_storage.finish(jobst_id, "Killed.", fail=True)
                raise
            else:
                job_storage.finish(jobst_id, '')
