# Generated by Django 1.11.16 on 2019-07-26 14:20

import datetime
import django.contrib.postgres.fields.jsonb
import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ClickedMarkedUrl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(max_length=255)),
                ('text', models.CharField(max_length=255)),
                ('long_clicks_count', models.PositiveIntegerField(default=0)),
                ('vital_marks_count', models.PositiveIntegerField(default=0)),
                ('relevant_marks_count', models.PositiveIntegerField(default=0)),
            ],
            options={
                'db_table': 'isearch_clickedmarkedurl',
            },
        ),
        migrations.CreateModel(
            name='ExternalWizardRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('search', models.CharField(max_length=50)),
                ('index', models.CharField(default='', max_length=50)),
                ('name', models.CharField(default='default', max_length=255)),
                ('rule', models.TextField()),
                ('params', models.CharField(default='', max_length=255)),
            ],
            options={
                'db_table': 'isearch_externalwizardrule',
            },
        ),
        migrations.CreateModel(
            name='Facet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('search', models.CharField(max_length=50)),
                ('index', models.CharField(default='', max_length=50)),
                ('backend', models.CharField(choices=[('platform', 'platform')], default='platform', max_length=10)),
                ('facet', models.CharField(max_length=255)),
                ('value', models.CharField(max_length=255)),
                ('label_ru', models.CharField(max_length=255)),
                ('label_en', models.CharField(max_length=255)),
            ],
            options={
                'db_table': 'isearch_facet',
            },
        ),
        migrations.CreateModel(
            name='Factor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('factor_id', models.PositiveIntegerField(default=0)),
                ('name', models.CharField(max_length=255)),
                ('service', models.CharField(default='intrasearch', max_length=64)),
            ],
            options={
                'db_table': 'isearch_factor',
            },
        ),
        migrations.CreateModel(
            name='Feature',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.CharField(db_index=True, default=None, max_length=255, null=True)),
                ('name', models.CharField(max_length=255)),
                ('group_id', models.PositiveIntegerField(default=None, null=True)),
                ('value', models.CharField(max_length=255)),
            ],
            options={
                'db_table': 'isearch_feature',
            },
        ),
        migrations.CreateModel(
            name='FerrymanTable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('batch_id', models.CharField(max_length=64, unique=True)),
                ('path', models.CharField(max_length=128)),
                ('status', models.CharField(choices=[('new', 'new'), ('queue', 'queue'), ('processing', 'processing'), ('final', 'final'), ('error', 'error')], default='new', max_length=64)),
            ],
            options={
                'db_table': 'isearch_ferrymantable',
            },
        ),
        migrations.CreateModel(
            name='Formula',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('search', models.CharField(max_length=50)),
                ('index', models.CharField(default='', max_length=50)),
                ('name', models.CharField(default='default', max_length=255)),
                ('service', models.CharField(default='', max_length=50)),
                ('polynomial', models.TextField()),
                ('compiled', models.TextField()),
                ('additional', models.CharField(default='', max_length=255)),
            ],
            options={
                'db_table': 'isearch_formula',
            },
        ),
        migrations.CreateModel(
            name='GroupAttr',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('search', models.CharField(max_length=50)),
                ('index', models.CharField(default='', max_length=50)),
                ('backend', models.CharField(choices=[('platform', 'platform')], default='platform', max_length=10)),
                ('name', models.CharField(max_length=255)),
                ('label_ru', models.CharField(max_length=255)),
                ('label_en', models.CharField(default='', max_length=255)),
                ('url', models.CharField(default='', max_length=255)),
                ('value', models.CharField(default='', max_length=255)),
            ],
            options={
                'db_table': 'isearch_groupattr',
            },
        ),
        migrations.CreateModel(
            name='Indexation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('search', models.CharField(max_length=50)),
                ('index', models.CharField(default='', max_length=50)),
                ('backend', models.CharField(choices=[('platform', 'platform')], default='platform', max_length=10)),
                ('start_time', models.DateTimeField()),
                ('end_time', models.DateTimeField(null=True)),
                ('last_check_at', models.DateTimeField(null=True)),
                ('documents_count', models.PositiveIntegerField(null=True)),
                ('expected_documents_count', models.PositiveIntegerField(null=True)),
                ('status', models.CharField(choices=[('new', 'new'), ('stop', 'stop'), ('done', 'done'), ('fail', 'fail')], default='new', max_length=10, null=True)),
                ('stdout', models.TextField(null=True)),
                ('stderr', models.TextField(null=True)),
                ('log', models.TextField(null=True)),
                ('swarm', models.BooleanField(default=True)),
                ('walk', models.BooleanField(default=True)),
                ('setup', models.BooleanField(default=True)),
                ('fetch', models.BooleanField(default=True)),
                ('create', models.BooleanField(default=True)),
                ('store', models.BooleanField(default=True)),
                ('delete', models.BooleanField(default=True)),
                ('load', models.BooleanField(default=True)),
                ('content', models.BooleanField(default=True)),
                ('options', django.contrib.postgres.fields.jsonb.JSONField(encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('comment', models.TextField(null=True)),
                ('user', models.CharField(max_length=250, null=True)),
                ('stats', models.TextField(null=True)),
                ('last_statist', models.DateTimeField(null=True)),
                ('load_conf', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
            ],
            options={
                'db_table': 'isearch_indexation',
            },
        ),
        migrations.CreateModel(
            name='IndexationStats',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hostname', models.CharField(max_length=255)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('stats', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('tick', models.PositiveIntegerField(default=0)),
                ('indexation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Indexation')),
            ],
            options={
                'db_table': 'isearch_indexationstats',
            },
        ),
        migrations.CreateModel(
            name='Job',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_time', models.DateTimeField(auto_now_add=True)),
                ('end_time', models.DateTimeField(null=True)),
                ('status', models.CharField(choices=[('new', 'new'), ('running', 'running'), ('done', 'done'), ('fail', 'fail')], default='new', max_length=10)),
                ('entity', models.CharField(max_length=255)),
                ('job_name', models.CharField(db_index=True, max_length=255)),
                ('message', models.TextField(default='')),
                ('options', models.TextField(blank=True, default='')),
            ],
            options={
                'db_table': 'isearch_job',
            },
        ),
        migrations.CreateModel(
            name='Mark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('request_id', models.CharField(max_length=64)),
                ('url', models.URLField()),
                ('score', models.CharField(choices=[('irrelevant', 'irrelevant'), ('relevant', 'relevant'), ('vital', 'vital')], max_length=32)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(default=django.utils.timezone.now)),
            ],
            options={
                'db_table': 'isearch_mark',
            },
        ),
        migrations.CreateModel(
            name='Node',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hostname', models.CharField(max_length=255)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('info', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
            ],
            options={
                'db_table': 'isearch_node',
            },
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('directory_id', models.PositiveIntegerField(unique=True)),
                ('directory_revision', models.PositiveIntegerField(default=0)),
                ('name', models.CharField(max_length=512)),
                ('label', models.CharField(max_length=256)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('deleted', models.BooleanField(default=False)),
                ('deletion_date', models.DateTimeField(null=True)),
            ],
            options={
                'db_table': 'isearch_organization',
            },
        ),
        migrations.CreateModel(
            name='PushInstance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(default=datetime.datetime.now)),
                ('status', models.SmallIntegerField(choices=[(1, 'new'), (2, 'fail'), (3, 'done'), (4, 'cancel'), (5, 'retry'), (6, 'known_fail')], default=1, null=True)),
                ('indexation', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.Indexation')),
            ],
            options={
                'db_table': 'isearch_pushinstance',
            },
        ),
        migrations.CreateModel(
            name='PushRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('search', models.CharField(max_length=50)),
                ('index', models.CharField(default='', max_length=50)),
                ('backend', models.CharField(choices=[('platform', 'platform')], default='platform', max_length=10)),
                ('date', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('type', models.CharField(max_length=100)),
                ('meta', django.contrib.postgres.fields.jsonb.JSONField(encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('comment', models.TextField(blank=True, default='', null=True)),
                ('object_id', models.CharField(db_index=True, default=None, max_length=50, null=True)),
                ('status', models.SmallIntegerField(choices=[(1, 'new'), (2, 'fail'), (3, 'done'), (4, 'cancel'), (5, 'retry'), (6, 'known_fail')], default=1, null=True)),
                ('start_time', models.DateTimeField(db_index=True, null=True)),
                ('end_time', models.DateTimeField(null=True)),
                ('retries', models.IntegerField(default=0, null=True)),
            ],
            options={
                'db_table': 'isearch_pushrecord',
            },
        ),
        migrations.CreateModel(
            name='Revision',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('search', models.CharField(max_length=50)),
                ('index', models.CharField(default='', max_length=50)),
                ('backend', models.CharField(choices=[('platform', 'platform')], default='platform', max_length=10)),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(
                    choices=[
                        ('new', '\u043d\u043e\u0432\u044b\u0439'),
                        ('broken', '\u0441\u043b\u043e\u043c\u0430\u043d\u043d\u044b\u0439'),
                        ('ready', '\u0433\u043e\u0442\u043e\u0432\u044b\u0439'),
                        ('deleted', '\u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439'),
                        ('active', '\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439'),
                    ],
                    db_index=True,
                    default='new',
                    max_length=10,
                )),
                ('service', models.CharField(default='', max_length=64)),
                ('latest_indexation_time', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'db_table': 'isearch_revision',
            },
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256)),
            ],
            options={
                'db_table': 'isearch_service',
            },
        ),
        migrations.CreateModel(
            name='StageStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status_id', models.CharField(db_index=True, max_length=100)),
                ('status', models.CharField(
                    choices=[
                        ('new', 'new'),
                        ('done', 'done'),
                        ('fail', 'fail'),
                        ('cancel', 'cancel'),
                        ('in progress', 'in progress'),
                        ('retry', 'retry'),
                    ],
                    default='new',
                    max_length=16,
                )),
            ],
            options={
                'db_table': 'isearch_stagestatus',
            },
        ),
        migrations.CreateModel(
            name='OrganizationRobotUser',
            fields=[
                ('organization', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='robot_user', serialize=False, to='core.Organization')),
                ('uid', models.BigIntegerField(db_index=True)),
                ('token', models.CharField(max_length=127)),
                ('expires_at', models.DateTimeField()),
            ],
            options={
                'db_table': 'isearch_organizationrobotuser',
            },
        ),
        migrations.AddField(
            model_name='service',
            name='organization',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Organization'),
        ),
        migrations.AddField(
            model_name='revision',
            name='organization',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Organization'),
        ),
        migrations.AddField(
            model_name='pushrecord',
            name='organization',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Organization'),
        ),
        migrations.AddField(
            model_name='pushinstance',
            name='push',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='instances', to='core.PushRecord'),
        ),
        migrations.AddField(
            model_name='pushinstance',
            name='revision',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.Revision'),
        ),
        migrations.AddField(
            model_name='indexationstats',
            name='revision',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Revision'),
        ),
        migrations.AddField(
            model_name='indexation',
            name='revision',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Revision'),
        ),
        migrations.AddField(
            model_name='groupattr',
            name='revision',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Revision'),
        ),
        migrations.AlterUniqueTogether(
            name='formula',
            unique_together={('search', 'index', 'name', 'service')},
        ),
        migrations.AddField(
            model_name='ferrymantable',
            name='revision',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Revision'),
        ),
        migrations.AlterUniqueTogether(
            name='feature',
            unique_together={('user', 'name')},
        ),
        migrations.AlterUniqueTogether(
            name='factor',
            unique_together={('name', 'service')},
        ),
        migrations.AddField(
            model_name='facet',
            name='revision',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Revision'),
        ),
        migrations.AlterUniqueTogether(
            name='externalwizardrule',
            unique_together={('search', 'index', 'name')},
        ),
        migrations.AlterUniqueTogether(
            name='clickedmarkedurl',
            unique_together={('url', 'text')},
        ),
        migrations.AlterUniqueTogether(
            name='pushinstance',
            unique_together={('push', 'indexation'), ('push', 'revision')},
        ),
        migrations.AlterUniqueTogether(
            name='indexationstats',
            unique_together={('indexation', 'hostname')},
        ),
        migrations.AlterIndexTogether(
            name='indexation',
            index_together={('status', 'backend')},
        ),
        migrations.AlterUniqueTogether(
            name='groupattr',
            unique_together={('search', 'index', 'backend', 'revision', 'name', 'value')},
        ),
        migrations.AlterUniqueTogether(
            name='facet',
            unique_together={('search', 'index', 'backend', 'revision', 'facet', 'value')},
        ),
    ]
