from django.db import migrations
from django.contrib.auth import models as md


def add_wiki_permission(apps, schema_editor):
    wiki_perm = md.Permission.objects.filter(name='view_suggest_wiki').first()
    if not wiki_perm:
        return
    full_ac_group = md.Group.objects.filter(name='Полный доступ').first()
    if full_ac_group:
        full_ac_group.permissions.add(wiki_perm)

    wiki_search_group = md.Group.objects.filter(name='Поиск по Вики').first()
    if wiki_search_group:
        wiki_search_group.permissions.add(wiki_perm)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0004_suggest_wiki_layer'),
    ]

    operations = [
        migrations.RunPython(add_wiki_permission)
    ]
