from django.db import migrations


def add_stackoverflow_revision(apps, schema_editor):

    Revision = apps.get_model('core', 'Revision')
    Organization = apps.get_model('core', 'Organization')
    org_intranet = Organization.objects.all().first()
    if not Revision.objects.filter(service='stackoverflow').exists() and org_intranet:
        Revision.objects.create(service='intrasearch_so',
                                status='done',
                                organization=org_intranet,
                                search='stackoverflow',
                                )


def add_stackoverflow_service(apps, schema_editor):
    Service = apps.get_model('core', 'Service')
    Organization = apps.get_model('core', 'Organization')
    org_intranet = Organization.objects.all().first()
    if not Service.objects.filter(name='stackoverflow').exists() and org_intranet:
        Service.objects.create(name='stackoverflow', organization=org_intranet)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0006_suggest_at_permissions'),
    ]

    operations = [
        migrations.RunPython(add_stackoverflow_service),
        migrations.RunPython(add_stackoverflow_revision)
    ]
