from django.db import migrations

from intranet.search.core.models import Feature

YANDEX_GROUP_ID = 962


def add_enable_stackoverflow(apps, schema_editor):
    if not Feature.objects.filter(name='enable_stackoverflow').exists():
        Feature.objects.create(name='enable_stackoverflow',
                               value='1',
                               group_id=YANDEX_GROUP_ID,
                               )


class Migration(migrations.Migration):
    dependencies = [
        ('core', '0009_add_org_type'),
    ]

    operations = [
        migrations.RunPython(add_enable_stackoverflow),
    ]
