from django.db import migrations


def add_map_revision(apps, schema_editor):
    Revision = apps.get_model('core', 'Revision')
    Organization = apps.get_model('core', 'Organization')
    org_intranet = Organization.objects.filter(name='Yandex').first()
    if not Revision.objects.filter(service='map').exists() and org_intranet:
        Revision.objects.create(service='intrasearch_map',
                                status='done',
                                organization=org_intranet,
                                search='map',
                                )


def add_map_service(apps, schema_editor):
    Service = apps.get_model('core', 'Service')
    Organization = apps.get_model('core', 'Organization')
    org_intranet = Organization.objects.filter(name='Yandex').first()
    if not Service.objects.filter(name='map').exists() and org_intranet:
        Service.objects.create(name='map', organization=org_intranet)


class Migration(migrations.Migration):
    dependencies = [
        ('core', '0016_last_wiki_pk'),
    ]

    operations = [
        migrations.RunPython(add_map_service),
        migrations.RunPython(add_map_revision)
    ]
