from django.db import migrations
from django.contrib.auth import models as md


def add_map_perm(apps, schema_editor):
    map_perm = md.Permission.objects.filter(name='view_mapsearch').first()
    if not map_perm:
        return
    full_ac_group = md.Group.objects.filter(name='Полный доступ').first()
    if full_ac_group:
        full_ac_group.permissions.add(map_perm)


class Migration(migrations.Migration):
    dependencies = [
        ('core', '0017_map'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='organization',
            options={
                'permissions': [
                    ('search_public_wiki_pages', 'search_public_wiki_pages'),
                    ('view_search', 'view_search'),
                    ('view_docsearch', 'view_docsearch'),
                    ('view_peoplesearch', 'view_peoplesearch'),
                    ('view_wikisearch', 'view_wikisearch'),
                    ('view_stsearch', 'view_stsearch'),
                    ('view_atsearch', 'view_atsearch'),
                    ('view_statsearch', 'view_statsearch'),
                    ('view_legosearch', 'view_legosearch'),
                    ('view_femidasearch', 'view_femidasearch'),
                    ('view_candidatesearch', 'view_candidatesearch'),
                    ('view_goalsearch', 'view_goalsearch'),
                    ('view_abcsearch', 'view_abcsearch'),
                    ('view_csearch', 'view_csearch'),
                    ('view_mlsearch', 'view_mlsearch'),
                    ('view_yasensearch', 'view_yasensearch'),
                    ('view_stackoverflowsearch', 'view_stackoverflowsearch'),
                    ('view_moebiussearch', 'view_moebiussearch'),
                    ('view_mapsearch', 'view_mapsearch'),
                    ('view_suggest_base', 'view_suggest_base'),
                    ('view_suggest_people', 'view_suggest_people'),
                    ('view_suggest_doc', 'view_suggest_doc'),
                    ('view_suggest_nav', 'view_suggest_nav'),
                    ('view_suggest_wiki', 'view_suggest_wiki'),
                    ('view_suggest_atushka', 'view_suggest_atushka'),
                    ('view_suggest_services', 'view_suggest_services'),
                    ('view_suggest_queues', 'view_suggest_queues'),
                    ('view_suggest_issues', 'view_suggest_issues'),
                    ('view_suggest_ml', 'view_suggest_ml'),
                    ('view_suggest_idm_rolenodes', 'view_suggest_idm_rolenodes'),
                    ('view_suggest_idm_users', 'view_suggest_idm_users'),
                    ('view_suggest_idm_groups', 'view_suggest_idm_groups'),
                    ('view_suggest_idm_subjects', 'view_suggest_idm_subjects'),
                    ('view_suggest_groups', 'view_suggest_groups'),
                    ('view_suggest_invite', 'view_suggest_invite'),
                    ('view_suggest_clinics', 'view_suggest_clinics'),
                ]
            },
        ),
        migrations.RunPython(add_map_perm),
    ]
