from django.db import migrations


def add_help_revision(apps, schema_editor):
    Revision = apps.get_model('core', 'Revision')
    Organization = apps.get_model('core', 'Organization')
    org_intranet = Organization.objects.filter(name='Yandex').first()
    if not Revision.objects.filter(search='help').exists() and org_intranet:
        Revision.objects.create(
            service='intrasearch', status='done',
            organization=org_intranet, search='help',
        )


def add_help_service(apps, schema_editor):
    Service = apps.get_model('core', 'Service')
    Organization = apps.get_model('core', 'Organization')
    org_intranet = Organization.objects.filter(name='Yandex').first()
    if not Service.objects.filter(name='help').exists() and org_intranet:
        Service.objects.create(name='help', organization=org_intranet)


class Migration(migrations.Migration):
    dependencies = [
        ('core', '0018_map_perms'),
    ]

    operations = [
        migrations.RunPython(add_help_service),
        migrations.RunPython(add_help_revision)
    ]
