from funcparserlib.parser import NoParseError

from .parser import parse, tokenize, tokenize_fallback, Token
from .ast import get_kids, _Operator  # noqa


class ParseError(Exception):
    pass


def parse_query(query, sanitize=False, text_fallback=True):
    """ Парсит запрос в дерево

    sanitize - принимает True, False, или число попыток вырезать проблемные токены
    text_fallback - не пытаться покинуть омск

    """
    query = query.strip()

    tokens = tokenize(query)

    msg = None
    error = None
    for _ in range(int(sanitize) + 1):
        try:
            return parse(tokens)
        except NoParseError as exc:
            error = exc
            if msg is None:
                msg = exc.msg

            if sanitize:
                index = exc.state.max

                try:
                    tok = tokens[index]
                except IndexError:
                    # значит ожидались еще токены, но не пришли. Не
                    # понятно как разруливать такое
                    continue

                if tok.type == 'TEXT' and index > 0:
                    # если ошибка произошла на текстовом токене, скорее
                    # всего виноват предыдущий
                    index = index - 1
                    tok = tokens[index]

                new_tok = Token('TEXT', tok.value, tok.start, tok.end)
                tokens[index] = new_tok
    else:
        if not text_fallback:
            raise ParseError(error)
        else:
            return parse(tokenize_fallback(query))
