from schematics.models import Model
from schematics.types import StringType, IntType, BaseType, URLType, DateTimeType, LongType
from schematics.types.compound import ListType, ModelType

from intranet.search.core.snippets.base import CommonSnippet, register, DateTimeStampType, BaseSnippet


class AtAuthorModel(Model):
    login = StringType(required=True)
    name = StringType(required=True)
    name_en = StringType(required=True)
    qu = IntType(required=True)


class BaseAtSnippet(CommonSnippet):
    type = StringType(choices=('post', 'comment'), required=True)
    entry_type = StringType(required=True)


class ClubInfoType(BaseType):
    pass


class ThreadSnippet(BaseAtSnippet):
    updated = DateTimeStampType(serialized_format='%s', required=True)
    content = StringType(required=True)
    tags = ListType(StringType(required=True))
    author = ModelType(AtAuthorModel, required=True)
    comments_count = IntType(required=True)
    likes = IntType(required=True)
    dislikes = IntType(required=True)
    reposts_count = IntType(required=False, default=0)
    club = ClubInfoType(required=False, serialize_when_none=False)

    _fields_to_highlight = ('content', 'tags', 'author')


class PostSnippet(ThreadSnippet):
    updated = DateTimeType(required=True, serialized_format='%Y-%m-%dT%H:%M:%S%z')


class CommentSnippet(BaseAtSnippet):
    pass


class ClubSnippet(BaseSnippet):
    DATE_FORMATS = ('%Y-%m-%dT%H:%M:%S.%f', '%Y-%m-%dT%H:%M:%S', '%Y-%m-%d %H:%M:%S')
    SERIALIZED_FORMAT = '%Y-%m-%d %H:%M:%S'

    id = LongType(required=True)
    url = URLType(required=True)
    name = StringType()
    description = StringType()
    members_count = IntType()
    threads_count = IntType()
    first_post_date = DateTimeType(formats=DATE_FORMATS, serialized_format=SERIALIZED_FORMAT)
    last_post_date = DateTimeType(formats=DATE_FORMATS, serialized_format=SERIALIZED_FORMAT)
    userpic = StringType()
    community_type = StringType()

    _fields_to_highlight = ('name', 'description')


register('at', PostSnippet)
register('at', ThreadSnippet)
register('at', ClubSnippet)
