from schematics.models import Model
from schematics.types import StringType, URLType, DateTimeType, BooleanType, IntType
from schematics.types.compound import ListType, ModelType

from intranet.search.core.snippets.base import BaseSnippet, Breadcrumb, register


class ConductorBaseSnippet(BaseSnippet):
    url = URLType(required=True)
    title = StringType(required=True)
    description = StringType(required=False)
    created = DateTimeType()
    updated = DateTimeType()
    breadcrumbs = ListType(ModelType(Breadcrumb))

    _fields_to_highlight = ('title', 'description', 'breadcrumbs')


class RelatedItem(Model):
    url = StringType()
    title = StringType()


class DeployGroupSnippet(RelatedItem):
    repo_branch = StringType()


class ProjectsSnippet(ConductorBaseSnippet):
    service_name = StringType()
    mailto = StringType()
    root_email = StringType()
    testing_email = StringType()

register('projects', ProjectsSnippet)


class HostsSnippet(ConductorBaseSnippet):
    datacenter = ModelType(RelatedItem)
    group = ModelType(RelatedItem)
    tags = ListType(StringType)

register('hosts', HostsSnippet)


class GroupsSnippet(ConductorBaseSnippet):
    project = ModelType(RelatedItem)
    hosts = ListType(ModelType(RelatedItem))
    parent_groups = ListType(ModelType(RelatedItem))
    child_groups = ListType(ModelType(RelatedItem))
    tags = ListType(StringType)

register('groups', GroupsSnippet)


class PackageVersions(Model):
    stable = StringType()
    testing = StringType()


class PackagesSnippet(ConductorBaseSnippet):
    versions = ModelType(PackageVersions)
    workflows = ListType(ModelType(RelatedItem))
    projects = ListType(ModelType(RelatedItem))
    tags = ListType(StringType)
    repos = ListType(ModelType(RelatedItem))
    services = ListType(ModelType(RelatedItem))
    preservices = ListType(ModelType(RelatedItem))

    deleted = BooleanType()
    install_delay = IntType()
    upgrade_only = BooleanType()
    version_named = BooleanType()
    replace_dots = BooleanType()
    strip_version_build = BooleanType()
    version_delimited = BooleanType()
    deploy_scope = IntType()
    comment_required = BooleanType()

    _fields_to_highlight = ConductorBaseSnippet._fields_to_highlight + (
        'version', 'workflows', 'projects', 'repos', 'tags', 'services', 'preservices'
    )

register('packages', PackagesSnippet)


class TicketSnippet(ConductorBaseSnippet):
    status = StringType()
    comment = StringType()
    branch = StringType()
    author = StringType()
    tasks = ListType(StringType)
    packages = ListType(ModelType(RelatedItem))

register('tickets', TicketSnippet)


class WorkflowSnippet(ConductorBaseSnippet):
    project = ModelType(RelatedItem)
    comment = StringType()
    deploy_groups = ListType(ModelType(DeployGroupSnippet))

register('workflows', WorkflowSnippet)


class WorkflowGroupSnippet(ConductorBaseSnippet):
    comment = StringType()

register('workflow_groups', WorkflowGroupSnippet)
