from schematics.models import Model
from schematics.types import StringType, IntType, BooleanType, FloatType
from schematics.types.compound import ListType, ModelType

from intranet.search.core.snippets.base import BaseSnippet, CommonSnippet, register, User


class CategoryType(Model):
    id = IntType(required=True)
    name = StringType(required=True)


class ProblemSnippet(CommonSnippet):
    id = IntType(required=True)
    person = ModelType(User, required=True)
    solution = StringType(required=True)
    categories = ListType(ModelType(CategoryType, required=True))

    _fields_to_highlight = ('title', 'description', 'author', 'solution', 'categories')

    class Options:
        serialize_when_none = False


register('femida', ProblemSnippet)


class ContactSnippet(Model):
    id = IntType(required=True)
    type = StringType(required=True)
    is_main = BooleanType()
    account_id = StringType()
    is_active = BooleanType()


class VacancySnippet(Model):
    id = IntType()
    name = StringType()
    status = StringType()
    is_hidden = BooleanType()
    access = ListType(StringType)


class SkillSnippet(Model):
    id = IntType()
    name = StringType()


class ProfessionSnippet(Model):
    id = IntType()
    name = StringType()
    name_en = StringType()
    professional_sphere_id = IntType()


class ApplicationSnippet(Model):
    id = IntType()
    is_active = BooleanType()
    is_archived = BooleanType()
    resolution = StringType()
    status = StringType()
    vacancy_id = IntType()


class TargetCitySnippet(Model):
    id = IntType()
    name_ru = StringType()
    name_en = StringType()


class CandidateSnippet(BaseSnippet):
    id = IntType(required=True)
    first_name = StringType(required=True)
    middle_name = StringType()
    last_name = StringType(required=True)
    login = StringType()
    city = StringType()
    contacts = ListType(ModelType(ContactSnippet))
    vacancies = ListType(ModelType(VacancySnippet))
    responsibles = ListType(StringType)
    skills = ListType(ModelType(SkillSnippet))
    is_duplicate = BooleanType()
    professions = ListType(ModelType(ProfessionSnippet))
    applications = ListType(ModelType(ApplicationSnippet))
    nohire_interviews_count = IntType()
    hire_interviews_count = IntType()
    hire_interviews_avg_grade = FloatType()
    skype_interviews_count = IntType()
    skype_interviews_avg_grade = FloatType()
    on_site_interviews_count = IntType()
    on_site_interviews_avg_grade = FloatType()
    modified = StringType()
    created = StringType()
    is_current_employee = BooleanType()
    status = StringType()
    target_cities = ListType(ModelType(TargetCitySnippet))
    tags = ListType(StringType)

    _fields_to_highlight = ()


register('femida', CandidateSnippet)
