from schematics.types import StringType, IntType

from intranet.search.core.snippets.base import CommonSnippet, register


class GoalsSnippet(CommonSnippet):
    comment = StringType(required=True)
    deadline = StringType()
    importance = IntType(required=True)
    status = StringType(required=True)

    _fields_to_highlight = ('description', 'comment', 'title', 'breadcrumbs')

    class Options:
        serialize_when_none = False

register('goals', GoalsSnippet)
