from schematics.types import (BooleanType, IntType, ListType, StringType,
                              URLType)

from intranet.search.core.snippets.base import BaseSnippet, register


class HelpSnippet(BaseSnippet):
    id = IntType(required=True)
    active = BooleanType(required=True)
    url = URLType(required=True)
    order_url = URLType(required=True)
    key_words = StringType(required=True)
    title = StringType(required=True)
    sla_days = IntType()
    sla_end_date = StringType()
    description = StringType()
    restrictions = ListType(StringType())

    _fields_to_highlight = ('description', 'title')


register('help', HelpSnippet)
