from schematics.models import Model
from schematics.types import StringType, URLType, BooleanType, IntType
from schematics.types.compound import ListType, ModelType

from intranet.search.core.snippets.base import User


class RolenodeAlias(Model):
    type = StringType()
    name = StringType()


class RolenodeSnippet(Model):
    object_type = StringType()
    title = StringType()
    system = StringType(required=True)
    slug = StringType(required=True)
    slug_path = StringType(required=True)
    parent_path = StringType()
    human_short = StringType()
    help = StringType()


class UserSnippet(User):
    object_type = StringType()
    email = StringType()
    url = URLType()
    department_name = StringType()
    is_active = BooleanType()


class AncestorSnippet(Model):
    id = IntType(required=True)
    name = StringType(required=True)


class GroupSnippet(Model):
    object_type = StringType()
    object_id = StringType(required=True)
    title = StringType(required=True)
    slug = StringType(required=True)
    url = URLType()
    state = StringType()
    type = StringType()
    ancestors = ListType(ModelType(AncestorSnippet))
