from schematics.models import Model
from schematics.types import StringType, URLType, IntType, BooleanType, ModelType

from intranet.search.core.snippets.base import BaseSnippet, register


class RoomsSnippet(BaseSnippet):
    id = IntType(required=True)
    name = StringType(required=True)
    map_url = URLType(required=True)
    floor_id = IntType(required=True)
    type_ru = StringType(required=True)
    type_en = StringType(required=True)
    floor_name = StringType(required=False)
    office_id = IntType(required=False)
    office_name = StringType(required=False)
    city_id = IntType(required=False)
    city_name = StringType(required=False)

    _fields_to_highlight = ('name', 'type', 'office_name', 'city_name')


class EquipmentSnippet(BaseSnippet):
    id = IntType(required=True)
    name = StringType(required=True)
    name_dns = StringType(required=True)
    description = StringType(required=True)
    coord_x = IntType(required=True)
    coord_y = IntType(required=True)
    floor_id = IntType(required=True)
    floor_name = StringType(required=False)
    office_id = IntType(required=False)
    office_name = StringType(required=False)
    city_id = IntType(required=False)
    city_name = StringType(required=False)
    type_id = IntType(required=True)
    type_ru = StringType(required=True)
    type_en = StringType(required=True)
    type = StringType(required=True)

    _fields_to_highlight = ('name', 'type')


class AvailableEquipmentModel(Model):
    marker_board = BooleanType(required=True)
    voice_conferencing = BooleanType(required=True)
    projector = IntType(required=True)
    game_console = StringType(required=True)
    screen = IntType(required=True)
    desk = BooleanType(required=True)
    guest_wifi = BooleanType(required=True)
    seats = IntType(required=True)
    cork_board = BooleanType(required=True)
    video_conferencing = StringType(required=True)


class ConferenceSnippet(RoomsSnippet):
    name_alternative = StringType(required=True)
    name_exchange = StringType(required=True)
    phone = StringType(required=True)
    capacity = StringType(required=True)
    equipment = ModelType(AvailableEquipmentModel, required=True)

    _fields_to_highlight = ('name', 'type', 'office_name', 'city_name')


register('conferences', ConferenceSnippet)
register('equipment', EquipmentSnippet)
register('rooms', RoomsSnippet)
