from schematics.models import Model
from schematics.types import StringType, URLType, IntType, BooleanType, FloatType
from schematics.types.compound import ModelType

from intranet.search.core.snippets.base import BaseSnippet, register


class CoverItem(Model):
    id = IntType()
    url = URLType()
    type = StringType()
    nda = BooleanType()


class MoebiusSnippet(BaseSnippet):
    url = URLType()
    title = StringType(required=True)
    description = StringType(required=True)
    subject = StringType(required=False)
    cover = ModelType(CoverItem, required=False)
    rating = FloatType(required=True)

    _fields_to_highlight = ('title', 'description', 'subject')


register('moebius', MoebiusSnippet)
