from schematics.models import Model
from schematics.types import StringType, URLType, IntType, BooleanType, ListType, DateTimeType
from schematics.types.compound import ModelType

from intranet.search.core.snippets.base import register, BaseSnippet
from intranet.search.core.snippets.directory import UserNameSnippet as UserNameItem


class DefaultStringType(StringType):
    def __init__(self, regex=None, max_length=None, min_length=None, **kwargs):
        kwargs['default'] = ''
        super().__init__(regex, max_length, min_length, **kwargs)


class RelatedItem(Model):
    id = IntType()
    title = StringType()
    slug = StringType()


class AffiliationCountersSnippet(Model):
    yandex = IntType()
    yamoney = IntType()
    external = IntType()


class GroupSnippet(Model):
    id = IntType()
    url = URLType(required=True)
    title = StringType(required=True)
    slug = StringType()
    description = StringType()
    type = StringType()
    service = ModelType(RelatedItem)
    department = ModelType(RelatedItem)
    affiliation_counters = ModelType(AffiliationCountersSnippet, required=True)


class StandardItem(Model):
    id = IntType()
    name = DefaultStringType()


class DepartmentItem(Model):
    id = IntType()
    url = DefaultStringType()
    dep_name = DefaultStringType()
    description = DefaultStringType()
    maillists = ListType(DefaultStringType, default=[])
    wiki = DefaultStringType()
    dep_name_short = DefaultStringType()


class PhoneItem(Model):
    description = DefaultStringType()
    value = DefaultStringType()
    type = DefaultStringType()


class ContactItem(Model):
    label = DefaultStringType()
    value = DefaultStringType()
    type = DefaultStringType()


class CarItem(Model):
    model = DefaultStringType()
    number = ListType(DefaultStringType())
    plate = DefaultStringType()


class BicycleItem(Model):
    description = DefaultStringType()
    number = DefaultStringType()


class TableItem(Model):
    id = IntType()
    number = IntType()


class OfficeItem(Model):
    id = IntType()
    code = DefaultStringType()
    name = DefaultStringType()


class WorkPlaceItem(Model):
    table = ModelType(TableItem)
    description = DefaultStringType()
    office = ModelType(OfficeItem)
    floor = ModelType(StandardItem)


class EducationItem(Model):
    status = DefaultStringType()
    area = DefaultStringType()
    place = DefaultStringType()


class KeyItem(Model):
    fingerprint = DefaultStringType()
    description = DefaultStringType()


class GapItem(Model):
    type = StringType()
    work_in_absence = BooleanType()

    # Gap возвращает даты в UTC, но без указания таймзоны, поэтому явно добавляем tzinfo
    date_from = DateTimeType(tzd='utc')
    date_to = DateTimeType(tzd='utc')


class PeopleSnippet(BaseSnippet):
    id = IntType(required=True)  # id на стаффе
    uid = DefaultStringType(required=True)  # яндексовый uid
    login = DefaultStringType(required=True)
    work_email = DefaultStringType(required=True)

    name = ModelType(UserNameItem, required=True)

    is_person = BooleanType(required=True)
    is_dismissed = BooleanType()
    is_robot = BooleanType(required=True)
    is_memorial = BooleanType(required=True)

    affiliation = DefaultStringType(required=True)

    department = ModelType(DepartmentItem, required=True)
    direction = ModelType(DepartmentItem, required=True)
    position = DefaultStringType(required=True)
    services = ListType(ModelType(StandardItem), default=[])
    duties = DefaultStringType()

    phones = ListType(ModelType(PhoneItem), default=[])
    contacts = ListType(ModelType(ContactItem), default=[])

    cars = ListType(ModelType(CarItem), default=[])
    bicycles = ListType(ModelType(BicycleItem), default=[])

    work_place = ModelType(WorkPlaceItem)

    education = ModelType(EducationItem)

    mobile_phone_model = DefaultStringType()
    birthday = DefaultStringType()
    address = DefaultStringType()
    tshirt_size = DefaultStringType()
    yandex_login = DefaultStringType()

    keys = ListType(ModelType(KeyItem), default=[])
    gaps = ListType(ModelType(GapItem), default=[])

    _fields_to_highlight = (
        'uid', 'login', 'work_email', 'name', 'department', 'direction', 'position', 'services',
        'duties', 'phones', 'contacts', 'cars', 'bicycles', 'work_place', 'education',
        'mobile_phone_model', 'birthday', 'address', 'tshirt_size', 'yandex_login', 'keys',
    )


register('people', PeopleSnippet)
