from schematics.models import Model
from schematics.types import StringType, URLType, IntType
from schematics.types.compound import ListType, ModelType, DictType

from intranet.search.core.snippets.base import BaseSnippet, register


class QueueSnippet(Model):
    """ Сниппет очередей стартрека
    """
    key = StringType(required=True)
    url = URLType(required=True)
    title = StringType()
    description = StringType()


class ComponentSnippet(Model):
    id = StringType()
    key = StringType()
    name = StringType()

    _fields_to_hilite = ('key', 'name')


class UserSnippet(Model):
    uid = IntType(required=False)
    login = StringType(required=True)
    name = StringType()

    _fields_to_hilite = ('name', )


class ProjectSnippet(Model):
    name = StringType()
    name_en = StringType()
    id = StringType()
    _fields_to_hilite = ('name', 'name_en')


class ServiceSnippet(Model):
    id = IntType()
    name = StringType()
    _fields_to_hilite = ('name', )


class AttachmentSnippet(Model):
    id = StringType()
    name = StringType()
    url = StringType()
    thumbnail_url = StringType()
    created = StringType()
    mimetype = StringType()

    _fields_to_hilite = ('name', )


class IssueSnippet(BaseSnippet):
    """ Сниппет задач стартрека
    """
    queue = ModelType(ComponentSnippet, required=True)
    key = StringType(required=True)
    summary = StringType()
    components = ListType(ModelType(ComponentSnippet))
    tags = ListType(StringType)
    assignee = ModelType(UserSnippet)
    priority = ModelType(ComponentSnippet)
    description = StringType()
    status = ModelType(ComponentSnippet)
    resolution = ModelType(ComponentSnippet)
    author = ModelType(UserSnippet)
    created = StringType()
    updated = StringType()
    due_date = StringType()
    project = ModelType(ProjectSnippet)
    services = ListType(ModelType(ServiceSnippet))
    additional = DictType(StringType)
    attachments = ListType(ModelType(AttachmentSnippet))

    _fields_to_highlight = ('key', 'summary', 'description', 'tags',
                            'components', 'author', 'assignee', 'queue', 'project')

register('st', IssueSnippet)
register('tracker', IssueSnippet)
