from schematics.types import BooleanType, DateTimeType, IntType, ListType, StringType, URLType
from intranet.search.core.snippets.base import BaseSnippet, register


class StackOverFlowSnippet(BaseSnippet):
    url = URLType(required=True)
    title = StringType(required=True)
    description = StringType()
    updated = DateTimeType()
    is_answered = BooleanType()
    tags = ListType(StringType())
    answer_count = IntType()
    score = IntType()
    _fields_to_highlight = ('description', 'title')


register('stackoverflow', StackOverFlowSnippet)
