from schematics.models import Model
from schematics.types import StringType, BooleanType, DateTimeType
from schematics.types.compound import ListType, ModelType

from intranet.search.core.snippets.base import BaseSnippet, register, DomainChangingURLType


class WikiBreadcrumb(Model):
    name = StringType()
    url = StringType()


class WikiSnippet(BaseSnippet):
    SERIALIZED_FORMAT = '%Y-%m-%d %H:%M:%S'
    DATE_FORMATS = (
        '%Y-%m-%dT%H:%M:%S.%f',
        '%Y-%m-%dT%H:%M:%S',
        '%Y-%m-%dT%H:%M:%S.%fZ',
        '%Y-%m-%dT%H:%M:%SZ',
        SERIALIZED_FORMAT
    )

    url = DomainChangingURLType()

    title = StringType()
    description = StringType(required=True)

    breadcrumbs = ListType(ModelType(WikiBreadcrumb))

    modtime_timestamp = StringType()
    modtime = DateTimeType(formats=DATE_FORMATS, serialized_format=SERIALIZED_FORMAT)

    public = StringType()
    is_empty = BooleanType()
    is_documentation = BooleanType()
    is_translated = BooleanType()
    is_auto_translated = BooleanType()

    _fields_to_highlight = ('description', 'breadcrumbs', 'title')

    class Options:
        serialize_when_none = True


register('wiki', WikiSnippet)
