from importlib import import_module


def load(search, index):
    """ Загружает код индексатора
    """
    try:
        if index == '':
            try:
                source = import_module(
                    'intranet.search.core.sources.{search}.{search}'.format(search=search))
            except ImportError:
                source = import_module(
                    f'intranet.search.core.sources.{search}')

        else:
            source = import_module(
                f'intranet.search.core.sources.{search}.{index}')
        return source.Source
    except (ImportError, AttributeError):
        raise ImportError(f'No source indexer for search: {search} {index}')
