from intranet.search.core.snippets.conductor import GroupsSnippet
from intranet.search.core.sources.conductor.base import SourceBase


class Source(SourceBase):
    """ Индексатор групп
    """
    source = 'groups'
    source_label = 'группа'
    source_label_plural = 'группы'
    stat_factor_prefix = 'group'
    need_fetch = True
    snippet_class = GroupsSnippet

    def do_fetch(self, obj, **kwargs):
        kwargs = {
            'tags': self.fetch_related(obj, 'tags') or [],
            'project': self.fetch_related_one(obj, 'project'),
            'parent_groups': self.fetch_related(obj, 'parents') or [],
            'child_groups': self.fetch_related(obj, 'children') or [],
            'hosts': self.fetch_related(obj, 'hosts') or [],
            'workflows': self.fetch_related(obj, 'workflows') or [],
        }
        self.next('create', obj=obj, **kwargs)

    def create_body(self, obj, **kwargs):
        data = obj['attributes']
        body = {
            'description': data['description'] or '',
        }
        if kwargs['project']:
            body['related_project'] = {
                'project_name': kwargs['project']['attributes']['name'] or '',
                'project_description': kwargs['project']['attributes']['description'] or '',
            }

        hidden = {
            'name': data['name'],
        }
        if kwargs.get('extra_info'):
            hidden['nanny'] = {
                'nanny_service_name': data.get('l7_nanny_service_name', ''),
                'nanny_service_port': data.get('nanny_service_port', ''),
            }

        for field in ('tags', 'parent_groups', 'child_groups', 'workflows'):
            if kwargs[field]:
                hidden['related_%s' % field] = [t['attributes']['name'] for t in kwargs[field]]

        if kwargs['hosts']:
            hidden['related_hosts'] = [t['attributes']['fqdn'] for t in kwargs['hosts']]

        body['hidden'] = hidden
        return body

    def create_snippet(self, obj, lang='ru', **kwargs):
        snippet = super().create_snippet(obj, lang, **kwargs)
        snippet['project'] = self.dump_related(kwargs['project'])
        for field in ('tags', 'parent_groups', 'child_groups'):
            snippet[field] = [self.dump_related(t) for t in kwargs[field]]

        if kwargs.get('hosts'):
            snippet['hosts'] = [
                {'title': t['attributes']['fqdn'], 'url': self.get_doc_url(t)}
                for t in kwargs['hosts']
            ]
        return GroupsSnippet(snippet)
