from intranet.search.core.snippets.conductor import WorkflowGroupSnippet
from intranet.search.core.sources.conductor.base import SourceBase


class Source(SourceBase):
    """ Индексатор групп вокфлоу
    """
    source = 'workflow_groups'
    source_label = 'группа воркфлоу'
    source_label_plural = 'группы воркфлоу'
    stat_factor_prefix = 'workflowGroup'
    snippet_class = WorkflowGroupSnippet

    def create_body(self, obj, **kwargs):
        data = obj['attributes']
        return {
            'comment': data['comment'] or '',
            'hidden': {
                'name': data['name']
            }
        }

    def create_snippet(self, obj, lang='ru', **kwargs):
        snippet = super().create_snippet(obj, lang, **kwargs)
        snippet['comment'] = obj['attributes']['comment'] or ''
        return snippet
