import os

from intranet.search.core.sources.directory.client import DirectoryApiClient, ObjectDoesNotExist

from intranet.search.core.swarm.api_indexer import PagedApiIndexer
from intranet.search.abovemeta.utils import string_to_bool

# TODO эксперимент для ISEARCH-5830: пробуем при индексации директории
# стадии create и store не запускать отдельными локальными тасками, а фетчи выполнять
# в глобальной очереди
GLOBAL_QUEUES_EXPERIMENT = string_to_bool(os.environ.get('ISEARCH_GLOBAL_QUEUES_EXPERIMENT'))


class SourceBase(PagedApiIndexer):
    """ Базовый индексатор директории
    """
    doc_type = None
    default_options = PagedApiIndexer.default_options.copy()

    def __init__(self, *args, **kwargs):
        # по умолчанию всю директорию индексируем realtime, потому что здесь
        # куча мелких источников и сбрасывание состояния саас после индексаций
        # происходит сильно часто, что куда более накладно, чем индексация realtime
        self.default_options['nort'] = False
        self.default_options['global'] = GLOBAL_QUEUES_EXPERIMENT

        super(PagedApiIndexer, self).__init__(*args, **kwargs)
        self.api_client = DirectoryApiClient()

    def next(self, stage, *args, **kwargs):
        if GLOBAL_QUEUES_EXPERIMENT and stage in ('create', 'store'):
            self.options['noqueue'] = True
        super().next(stage, *args, **kwargs)

    def get_doc_url(self, obj):
        return '{}:{}:{}'.format(self.doc_type, self.org_directory_id, obj['id'])

    @property
    def org_directory_id(self):
        return self.options['revision']['organization']['directory_id']

    def _request_directory(self, page=1):
        raise NotImplementedError()

    def fetch_objects(self, page=1):
        data = self._request_directory(page)
        # поддерживаем ISEARCH-7356 (data может быть пустой)
        yield from data.get('result', [])

    def fetch_object(self, obj_id):
        """ Получение данных из апи директории об одном объекте
        """
        raise NotImplementedError

    def get_counts(self):
        data = self._request_directory()
        # поддерживаем ISEARCH-7356
        if not data:
            return 0, 0
        return data['pages'], data['total']

    def do_push(self, data, delete=False, **kwargs):
        if delete:
            self.do_delete(data)
            return

        try:
            obj = self.fetch_object(data['id'])
        except ObjectDoesNotExist:
            self.do_delete(data)
        else:
            self.next('create', obj=obj)
