import re
from itertools import chain


camel_case_re = re.compile(r'\b([A-Z]*[a-z]+[A-Z]+[A-Za-z]*|[A-Z]{3,}[a-z]+)\b')


def get_camelcase_keywords(text: str, add_full_words: bool = True) -> list[str]:
    res = []
    word: str
    for word in camel_case_re.findall(text):
        if not word:
            continue
        if add_full_words:
            res.append(word.lower())
        start_letter = 0
        subwords = []
        for pos, letter in enumerate(word):
            if not pos or letter.islower():
                continue
            surround_by_uppercase = (
                word[pos-1].isupper() and
                len(word)-1 > pos and
                word[pos+1].isupper()
            )
            if surround_by_uppercase:
                continue
            subwords.append(word[start_letter:pos].lower())
            start_letter = pos
        subwords.append(word[start_letter:].lower())
        res.append(' '.join(subwords))
        if len(subwords) > 2:
            for i in range(1, len(subwords)):
                res.append(' '.join(chain(
                    subwords[:i-1],
                    [subwords[i-1] + subwords[i]],
                    subwords[i+1:]
                )))
    return res


def get_links(parsed_page):
    return [(a.text.strip(), a.get('href').strip())
            for a in parsed_page.xpath('//a')
            if a.text and a.get('href')]
