from django.conf import settings

from intranet.search.core.swarm import Indexer
from intranet.search.core.utils import http


class SourceBase(Indexer):
    base_api = settings.ISEARCH['api']['femida']
    list_api = None
    item_api = None
    item_url = None
    page_size = 30

    def __init__(self, options):
        super().__init__(options)

        self.session = http.create_session(
            max_retries=3,
            headers=self.base_api[self.list_api].headers(),
        )

    def parse_keys(self):
        return {'id': self.options['keys']}

    def do_walk(self, url=None, **kwargs):
        keys = self.parse_keys()

        if keys.get('id'):
            for key in keys['id']:
                self.next('fetch', id=key)
            return

        if url is None:
            # параметр page не передаем - по умочлчанию и так будет запрошена первая страница,
            # но для кандидатов при этом по другому будет сформирован следующий url: пагинация
            # будет по курсору, а не страницам
            query = {'page_size': self.page_size}
            query.update(keys)
            url = self.base_api[self.list_api].url(query=query)

        data = http.call_with_retry(self.session.get, url, verify=settings.ISEARCH_CA_CERTS).json()
        for res in data['results']:
            self.next('create', result=res)

        if data['next']:
            self.next('walk', url=data['next'])

    def do_push(self, data, **kwargs):
        self.do_fetch(data['id'])

    def do_fetch(self, id, **kwargs):
        url = self.base_api[self.item_api].url().format(id=id)
        data = http.call_with_retry(self.session.get, url, verify=settings.ISEARCH_CA_CERTS).json()
        self.next('create', result=data)

    def get_doc_url(self, obj):
        return self.base_api[self.item_url].url().format(id=obj['id'])
