from intranet.search.core.snippets.help import HelpSnippet
from intranet.search.core.sources.help.base import HelpClientApi
from intranet.search.core.sources.utils import get_by_lang, get_text_content
from intranet.search.core.swarm.api_indexer import PagedApiIndexer


class Source(PagedApiIndexer):
    def __init__(self, options):
        super().__init__(options)
        self.api_client = HelpClientApi()

    def fetch_objects(self, page=1):
        objs = self.api_client.fetch_forms(page, filters={"type__in": "custom_form,ya_form"})
        return objs['result']

    def get_counts(self):
        data = self.api_client.fetch_forms(1)
        return data['pages'], data['total']

    def get_doc_url(self, obj):
        return self.api_client.form_api_url.format(id=obj['id'])

    def create_snippet(self, obj, lang='ru', **kwargs):
        data = {
            'id': obj['id'],
            'active': obj['active'],
            'url': obj['url'],
            'order_url': obj['order_url'],
            'key_words': obj['key_words'],
            'title': get_by_lang(obj['name'], lang),
            "sla_days": obj['sla_days'],
            "sla_end_date": obj['sla_end_date'],
            'description': get_by_lang(obj['description'], lang),
            'restrictions': obj['restrictions'],
        }

        return HelpSnippet(data)

    def create_body(self, obj, **kwargs):
        body = {
            'description': get_text_content(obj['description']['ru']),
            'z_ns_hidden': {
                'title': obj['name']['ru'],
                'key_words': obj['key_words'],
            },
        }
        return body
