from math import ceil
from django.conf import settings
from django.utils.functional import cached_property

from intranet.search.core.utils import http


class IDMApiClient:
    api_conf = settings.ISEARCH['api']['idm']
    per_page = 500
    timeout = None

    @cached_property
    def session(self):
        session = http.create_session()
        session.headers.update(self.api_conf['api_v1'].headers())
        return session

    def fetch(self, url, **kwargs):
        response = http.call_with_retry(self.session.get, url, timeout=self.timeout,
                                        verify=settings.ISEARCH_CA_CERTS, **kwargs)
        return response.json()

    def fetch_page(self, source, **kwargs):
        """ Извлекает одну из страниц коллекции
        """
        params = {'limit': self.per_page}
        params.update(**kwargs)
        url = self.api_conf[source].url()
        return self.fetch(url, params=params)

    def pages_count(self, page_data):
        return ceil(float(page_data['meta']['total_count']) / page_data['meta']['limit'])
