import re


SPECIAL_CHARS_RE = re.compile(r'[\._\/\|-]')
SPECIAL_CHARS_SUB = ' '


def gen_options_by_special_chars(text):
    """ Генерирует варианты разбиения текста по специальным символам.

    >>> split_by_special_chars('conductor.renderer_carparks')
    [u'conductor renderer carparks', u'renderer carparks', u'carparks']
    """
    parts = SPECIAL_CHARS_RE.split(text)
    return [SPECIAL_CHARS_SUB.join(parts[i:]) for i in range(len(parts))]


def replace_special_chars(text):
    return SPECIAL_CHARS_RE.sub(SPECIAL_CHARS_SUB, text)
