from django.conf import settings
from intranet.search.core.sources.map.map import BaseRoomIndexer
from intranet.search.core.snippets.map import RoomsSnippet
from intranet.search.core.sources.map.utils import rooms_types_data


class Source(BaseRoomIndexer):
    """
    Индексатор комнат
    """

    def __init__(self, options, *args, **kwargs):
        self.rooms_url = settings.ISEARCH['map']['urls']['rooms']
        self.map_url = settings.ISEARCH['map']['urls']['rooms_map']
        super().__init__(options, *args, staff_repo_name='room', **kwargs)

    @property
    def searched_type(self):
        return {'ru': 'комната', 'en': 'room'}

    def do_walk(self, **kwargs):
        super().do_walk(excluded_room_types='conference', **kwargs)

    def create_body(self, obj):
        body = self.base_body(obj)
        return body

    def emit_additional_attributes(self, doc, obj):
        room_type = obj['type']
        doc.emit_suggest_attr(rooms_types_data[room_type])
        doc.emit_suggest_attr(room_type)

    def create_snippet(self, obj, lang='ru'):
        snippet = self.base_snippet(obj, lang)
        return RoomsSnippet(snippet)

    def gen_url(self, obj):
        return self.rooms_url.format(obj["id"])

    def gen_map_url(self, obj):
        map_url = self.map_url.format(obj['id'])
        return map_url
