import re

equipment_types_data = {  # TODO: попросить у стаффа ручку для перевода названий
    'printer': {'id': 0, 'ru': 'Принтер', 'en': 'Printer'},
    'scanner': {'id': 1, 'ru': 'Сканер', 'en': 'Scanner'},
    'copier': {'id': 2, 'ru': 'Копировальный аппарат', 'en': 'Copier'},
    'mfp': {'id': 3, 'ru': 'МФП', 'en': 'MFP'},
    'dect': {'id': 4, 'ru': 'Трубка', 'en': 'dect'},
    'wifi': {'id': 5, 'ru': 'Вайфай', 'en': 'Wi-Fi'},
    'rj45': {'id': 6, 'ru': 'Сетевой интерфейс rj45', 'en': 'rj45'},
    'fax': {'id': 7, 'ru': 'Факс', 'en': 'Fax'},
    'shredder': {'id': 8, 'ru': 'Бумагорезка', 'en': 'Shredder'},
    'stationery_cabinet': {'id': 9, 'ru': 'Канцелярские принадлежности', 'en': 'Stationery cabinet'},
    'hypercube': {'id': 10, 'ru': 'Гиперкуб', 'en': 'Hypercube'},
    'sensor': {'id': 11, 'ru': 'Датчик', 'en': 'Sensor'},
    'zombie': {'id': 12, 'ru': 'Роботы-зомбики', 'en': 'Zombie'},
    'wifi_mount_platform': {'id': 13, 'ru': 'Платформа монтирования вайфай', 'en': 'Wi-Fi mount platform'},
    'wifi_sensor': {'id': 14, 'ru': 'Вайфай датчик', 'en': 'Wi-Fi sensor'},
    'vending_machine': {'id': 15, 'ru': 'Вендинговый автомат', 'en': 'Vending machine'},
    'help_machine': {'id': 16, 'ru': 'Автомат-помощник', 'en': 'Help machine'},
    'atm': {'id': 17, 'ru': 'Банкомат', 'en': 'ATM'},
    'massage_chair': {'id': 18, 'ru': 'Массажное кресло', 'en': 'Massage chair'},
    'battery_recycling_container': {'id': 19, 'ru': 'Контейнер переработки батареек', 'en': 'Battery recycling container'},
    'sleep_capsule': {'id': 20, 'ru': 'Капсула сна', 'en': 'Sleep capsule'},
    'photo_booth': {'id': 21, 'ru': 'Фотобудка', 'en': 'Photo booth'},
    'photo_spot': {'id': 22, 'ru': 'Фото', 'en': 'Photo spot'},
}

rooms_types_data = {
    'office': 'кабинет',
    'conference': 'переговорка',
    'coffee': 'кофе',
    'wc': 'туалет',
    'wardrobe': 'гардероб',
    'warehouse': 'склад',
    'service': 'служебное помещение',
    'shower': 'душ',
    'gym': 'спортивный зал',
    'library': 'библиотека',
    'coworking': 'коворкинг',
    'stairs': 'лестница',
    'switch': 'ЭКЦ',  # TODO: что это?
    'hallway': 'прихожая',
    'balcony': 'балкон',
    'phone_booth': 'телефонная будка',
    'smoking': 'курилка',
}


def split_by_not_letters(string_to_split):
    # посплитит по всему, что не буква русского или латинского алфавита или цифра
    splitted_string = re.split(r'[^a-zA-ZА-Яа-я0-9]+', string_to_split)
    return splitted_string


def get_enumerated_name(checked_name):
    # строка вида  цифра точка что угодно длиной > 1 символа
    check_result = re.match(r'^(\d)\.(.+)', checked_name, re.UNICODE)
    return check_result


def number_to_words(number):
    numbers = {
        '1': ['один', 'первый'],
        '2': ['два', 'второй'],
        '3': ['три', 'третий'],
        '4': ['четыре', 'четвёртый'],
        '5': ['пять', 'пятый'],
        '6': ['шесть', 'шестой'],
        '7': ['семь', 'седьмой'],
    }
    return numbers.get(number, [])
