import re


def get_ml_name(email):
    # http://ml.yandex-team.ru/lists/isearch-dev
    parts = email.split('/')
    if len(parts) > 1:
        return parts[-1]

    parts = email.split('@')
    if len(parts) > 1:
        name, domain = parts
        if domain == 'yandex-team.ru':
            return name
    return email


def is_trash(name):
    sep = bool(re.search(r'-|_', name))

    if not sep:
        return False

    buzz_words = [r'robots', r'svn', r'git', r'cvs',
                  r'commits', r'monitoring', r'test',
                  r'tests', r'deploy', r'report', r'logs']

    return bool(re.search(
        r'|'.join(r'((^|\W)%s(\W|$))' % word for word in buzz_words), name))
