from django.conf import settings
from django.utils.functional import cached_property

from intranet.search.core.utils import http
from intranet.search.core.tvm import tvm2_client


class MoebiusApiClient:
    page_size = 100
    api_conf = settings.ISEARCH['api']['moebius']
    courses_api_url = api_conf['courses'].url()
    course_api_url = api_conf['course_detail'].url()

    @cached_property
    def session(self):
        session = http.create_session()
        service_ticket = tvm2_client.get_service_ticket('moebius')
        session.headers[settings.TVM2_SERVICE_HEADER] = service_ticket
        return session

    def fetch(self, url, **kwargs) -> dict:
        response = http.call_with_retry(self.session.get, url, **kwargs)
        return response.json()

    def fetch_page(self, page: int = 1) -> dict:
        return self.fetch(self.courses_api_url, params={'page': page, 'limit': self.page_size})

    def fetch_course(self, course_id: int) -> dict:
        return self.fetch(self.course_api_url.format(id=str(course_id)))
