from intranet.search.core.utils.http import absolute_url


SERVICE_STATE_MAP = {
    'develop': {
        'ru': 'развивается',
        'factor': 'isServiceDeveloping'
    },
    'supported': {
        'ru': 'поддерживается',
        'factor': 'isServiceSupported',
    },
    'closed': {
        'ru': 'закрыт',
        'factor': 'isServiceClosed',
    },
    'deleted': {
        'ru': 'удален',
    },
    'needinfo': {
        'ru': 'требуется информация',
    },
}


SERVICE_TRAFFIC_LIGHT_MAP = {
    '1clarity': 'isClear',
    '2team': 'hasValidTeam',
    '3structure': 'hasValidStructure',
    '4resources': 'hasClearResources',
    '5children': 'hasClearChildren',
}

SERVICE_TRAFFIC_LIGHT_VALUE_MAP = {
    'ok': 1,
    'warning': 0.5,
    'critical': 0,
}


# Note: порядок важен – в таком порядке контакты отдаются в сниппете
contact_types = {
    'url_wiki': {
        'url': 'https://wiki.yandex-team.ru',
        'title': {'ru': 'Вики-страница', 'en': 'Wiki'},
    },
    'url_at_club': {
        'url': 'https://clubs.at.yandex-team.ru',
        'title': {'ru': 'Клуб в Этушке', 'en': 'Blog'}
    },
    'email_ml': {
        'url': 'https://ml.yandex-team.ru/lists/',
        'default_title': {'ru': 'Рассылка', 'en': 'Maillist'}
    },
    'tracker_startrek': {
        'url': 'https://st.yandex-team.ru',
    },
    'url_sitelink': {
        'default_title': {'ru': 'Адрес сайта', 'en': 'Site url'}
    },
    'url_doc': {
        'default_title': {'ru': 'Документация', 'en': 'Documentation'}
    },
    'vcs': {
        'default_title': {'ru': 'Репозиторий', 'en': 'Repository'}
    },
    'url_statface': {
        'default_title': {'ru': 'Статистика', 'en': 'Statface'}
    },
}


def normalize_url(url, _type='url_wiki'):
    if not url:
        return ''

    return absolute_url(url, contact_types.get(_type, {}).get('url'))
