from intranet.search.core.sources.st.base import BaseTrackerIssuesIndexer
from intranet.search.core.sources.utils import Services, get_by_lang


class Source(BaseTrackerIssuesIndexer):
    QUEUE_SEARCH_ATTRS = {
        'JOB': ['candidate'],
        'YASEN': [
            'copyrightHolder',  # правообладатель
            'sourceDescription',  # источник
            'license',  # лицензия
            'start',  # начало срока лицензии
            'end',  # конеу срока лицензии
            'countryNew',  # территория
            'typeOfContract',  # способы использования
            'thumbnailId',  # id основной картинки
        ],
    }
    need_content = True

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.services = Services(self.cache_storage, key_field='id', fields=('id', 'name'))

    def extra_fetch(self, issue):
        services = []
        if issue.get('abcService'):
            for service in issue['abcService']:
                if not service.get('name'):
                    service['name'] = self.services[service['id']].get('name', {})
                services.append(service)
        issue['services'] = services

    def emit_facet_attrs(self, doc, issue, queue):
        super().emit_facet_attrs(doc, issue, queue)

        for component in issue.components or []:
            ru_data = self.get_data(component, 'ru')
            en_data = self.get_data(component, 'en')
            doc.emit_facet_attr('component', ru_data['id'], ru_data['name'], en_data['name'])

        for service in issue.get('services'):
            doc.emit_facet_attr(
                name='service',
                value=service['id'],
                label=get_by_lang(service.get('name'), 'ru'),
                label_en=get_by_lang(service.get('name'), 'en'),
            )
