from django.conf import settings
from lxml.etree import ParserError

from intranet.search.core.sources.utils import get_text_content


def sanitized_text(resource, key_html, key_text=None):
    if resource.get(key_html):
        return sanitize(resource[key_html])
    if resource.get(key_text):
        return sanitize(resource[key_text])
    return ''


def display(data, lang='ru'):
    if data is None:
        return ''

    if not isinstance(data, dict):
        return data

    displ = data['display']
    if isinstance(displ, dict):
        return displ.get(lang, displ['ru'])
    else:
        return displ


class AttrDict(dict):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.__dict__ = self

    def __getattr__(self, name):
        if name not in self:
            return None


def sanitize(text):
    try:
        return get_text_content(text)
    except ParserError:
        return ''


def get_group_attrs_for_factor_by_uid(uid, factor_name):
    """ Разбивает uid на части для подсчета пользовательских факторов в саас.
    uid - это int64, подсчет пользовательских факторов в саас не умеет с этим работать
    и его нужно разделить на части не больше int32.
    Подробности здесь: https://st.yandex-team.ru/ISEARCH-5531#1533639908000
    """
    uid = str(uid)
    # В api трекера у некоторых пользователь указан неверный uid, который может быть длинны 1.
    # В этом случае не делим его на несколько частей.
    if len(uid) == 1:
        return [(factor_name, uid)]
    border = int(len(uid) / 2)
    result = [
        (f'{factor_name}1', int(uid[:border])),
        (f'{factor_name}2', int(uid[border:]))
    ]
    return result


def is_issue_in_blacklist(issue_key):
    queue = issue_key.split('-')[0]
    return queue in settings.ISEARCH_TRACKER_QUEUES_BLACKLIST


def get_issue_number(issue):
    return int(issue['key'].split('-')[1])
