from logging import getLogger

from intranet.search.core.sources.stackoverflow.base import SourceBase

log = getLogger(__name__)


class Source(SourceBase):
    """ Индексатор cтатей
    """
    source = 'articles'
    source_singular = 'article'
    source_label = 'статья'
    source_label_plural = 'статьи'
    # stat_factor_prefix = 'article'
    need_fetch = True

    def do_fetch(self, obj, **kwargs):
        obj_id = obj['article_id']
        obj = self.fetch_object(obj_id)
        self.next('create', obj=obj)
