from logging import getLogger

from intranet.search.core.sources.st.base import BaseTrackerIssuesIndexer
from intranet.search.core.sources.st.utils import display
from intranet.search.core.sources.tracker.base import BisearchTrackerIndexerMixin


log = getLogger(__name__)


class Source(BisearchTrackerIndexerMixin, BaseTrackerIssuesIndexer):
    """
    Индексатор трекера в b2b
    """

    need_content = False

    def extra_fetch(self, issue):
        for field in ('createdBy', 'assignee'):
            if issue.get(field):
                try:
                    issue[field]['login'] = self.people_cache[issue[field]['id']]['nickname']
                except KeyError:
                    issue[field]['login'] = ''

    def get_person_data(self, data, lang='ru'):
        if not data:
            return {
                'uid': None,
                'login': 'none',
                'name': self.empty_data[lang],
            }

        return {
            'uid': data['id'],
            'login': data['login'],
            'name': display(data, lang),
        }
