import logging

from intranet.search.core.sources.wiki.base import BaseWikiSource
from intranet.search.core.utils import format_directory_group

log = logging.getLogger(__name__)


class Source(BaseWikiSource):
    catalog_timeout = 10
    vodstvo_parts = {'sandbox'}
    need_content = False

    def _get_headers(self):
        headers = super()._get_headers()
        headers['X-Org-Id'] = str(self.revision['organization']['directory_id'])
        return headers

    def do_setup(self, **kwargs):
        self.next('walk')

    def emit_factor(self, doc, name, value):
        doc.emit_factor(name, value)

    def emit_acl_groups_whitelist(self, doc, data):
        for group_data in data.get('acl_groups_whitelist', []):
            acl_group = format_directory_group(group_data)
            doc.emit_search_attr('acl_groups_whitelist', acl_group)
