import logging
from collections import defaultdict

from intranet.search.core.sources.utils import get_metrix_data, normalize

log = logging.getLogger(__name__)


def prepare_metrix(source='wiki'):
    try:
        data = get_metrix_data(source)
    except Exception as e:
        log.error(e)
        return

    result = defaultdict(int)

    for entry in data:
        path = entry['path']
        bits = path.split('/')
        if bits[-1].startswith('.'):
            path = '/'.join(bits[:-1]).lower() + '/'

        result[path] += entry['page_views']

    # 1000 - дефолт для нормирования
    for key, value in result.items():
        result[key] = normalize(value, 1000)

    return result


def is_trash_title(title):
    # Если в названии (заголовок, а не адрес) страницы более двух слэшей
    # Если название более 40 символов и при этом нет пробелов
    if title.count('/') > 2 or (title.count(' ') == 0 and len(title) > 40):
        return True
    return False
