from .base import Storage, ArtefactStorage, DoesNotExist, StorageUnavailable  # noqa
from .indexation import IndexationStorage  # noqa
from .revision import RevisionStorage  # noqa
from .feature import FeatureStorage  # noqa
from .formula import FormulaStorage  # noqa
from .external_wizard_rule import ExternalWizardRuleStorage  # noqa
from .stage_status import StageStatusStorage, LocalStageStatusStorage  # noqa
from .group_attr import GroupAttrStorage  # noqa
from .cache import DummyCacheStorage, CacheStorage  # noqa
from .profile import ProfileStorage  # noqa
from .facet import FacetStorage  # noqa
from .push import PushStorage  # noqa
from .job_storage import JobStorage  # noqa
from .organization import OrganizationStorage  # noqa
from .ferryman_table import FerrymanTableStorage  # noqa


class StorageRepository:
    def __init__(self):
        self.storages = {
            'feature': FeatureStorage(),
            'revision': RevisionStorage(),
            'formula': FormulaStorage(),
            'indexation': IndexationStorage(),
            'external_wizard_rule': ExternalWizardRuleStorage(),
            'organization': OrganizationStorage(),
        }

    def __getitem__(self, name):
        return self.storages[name]


class ArtefactStorageRepository(StorageRepository):
    def __init__(self, revision):
        self.revision = revision

        self.storages = {
            'group_attr': GroupAttrStorage(revision),
            'facets': FacetStorage(revision),
        }
