from collections import defaultdict

from django.forms import model_to_dict

from intranet.search.core.models import ExternalWizardRule

from .base import Storage


class ExternalWizardRuleStorage(Storage):
    def get(self, **kwargs):
        assert(not kwargs)
        return [model_to_dict(i) for i in ExternalWizardRule.objects.all()]

    def create(self, **kwargs):
        data = {
            'name': kwargs.pop('name'),
            'rule': kwargs.pop('rule'),
            'search': kwargs.pop('search'),
            'index': kwargs.pop('index'),
            'params': kwargs.pop('params'),
        }

        assert(not kwargs)

        rule = ExternalWizardRule(**data)
        rule.save()

    def update(self, **kwargs):
        id = kwargs.pop('id')
        data = {
            'name': kwargs.pop('name'),
            'rule': kwargs.pop('rule'),
            'params': kwargs.pop('params'),
        }

        assert(not kwargs)

        ExternalWizardRule.objects.filter(id=id).update(**data)

    def get_all(self):
        rules = ExternalWizardRule.objects.all()

        result = defaultdict(lambda: defaultdict(list))

        for rule in rules:
            result[rule.search][rule.index].append(rule)

        return dict(result)
