from django.forms import model_to_dict

from intranet.search.core.models import Feature
from intranet.search.core.utils import group_ids, get_ids_repository

from .base import Storage


class FeatureStorage(Storage):
    def get(self, **kwargs):
        user = kwargs.pop('user', None)
        groups = kwargs.pop('groups', [])

        assert(not kwargs)

        filter_params = {}
        if user:
            filter_params['user'] = user
        else:
            filter_params['group_id__in'] = groups

        return [model_to_dict(i) for i in Feature.objects.filter(**filter_params)]

    def get_feature(self, user, feature_name):
        try:
            data = Feature.objects.get(user=user, name=feature_name)
            return data.value
        except Feature.DoesNotExist:
            pass

        # получаем группы
        staff = get_ids_repository('staff', 'person')

        query = {
            'login': user,
            '_fields': 'groups.group.id,groups.group.ancestors.id',
        }

        groups = group_ids(staff.get_one(query))

        features = Feature.objects.filter(group_id__in=groups, name=feature_name)

        if features:
            return features[0].value

        return None
