from django.forms import model_to_dict

from intranet.search.core.models import Formula


from .base import Storage


class FormulaStorage(Storage):
    def create(self, **kwargs):
        base = {
            'search': kwargs.pop('search'),
            'index': kwargs.pop('index', ''),
            'name': kwargs.pop('name', 'default'),
            'service': kwargs.pop('service'),
        }

        polynomial = kwargs.pop('polynomial')
        compiled = kwargs.pop('compiled')
        additional = kwargs.pop('additional')
        id = kwargs.pop('id')

        assert(not kwargs)

        if id:
            formula = Formula.objects.get(id=id)
            formula.name = base['name']
            formula.service = base['service']
        else:
            formula, _ = Formula.objects.get_or_create(**base)

        formula.polynomial = polynomial
        formula.compiled = compiled
        formula.additional = additional
        formula.save()

        return formula.id

    def get(self, **kwargs):
        assert(not kwargs)
        return [model_to_dict(i) for i in Formula.objects.all()]
