import requests

from django.conf import settings


class TVM2Client:
    """ Класс для работы с API TVM2 (через кулаудную ручку для него):
    https://wiki.yandex-team.ru/passport/tvm2/qloud/
    """
    base_api = settings.ISEARCH['api']['tvm2']

    def __init__(self, client_id):
        self.client_id = client_id
        self.session = requests.Session()
        self.session.headers['Authorization'] = settings.TVM2_AUTH_TOKEN

    def get_service_ticket(self, dst):
        """ Возвращает сервисный тикет до определенного приемника
        """
        url = self.base_api['get_service_ticket'].url()
        response = self.session.get(url, params={'dsts': dst, 'src': self.client_id})

        response.raise_for_status()
        data = response.json()
        return data[dst]['ticket']

    def get_service_ticket_for(self, dst):
        """ Функция-алиас get_service_ticket, необходимая для совместимости с интерфейсом
        авторизации клиента логброкера
        """
        return self.get_service_ticket(dst)


tvm2_client = TVM2Client(settings.TVM2_CLIENT_NAME)
