from django.conf import settings
from django.core.exceptions import ImproperlyConfigured


def get_default_service(search, index):
    """ Возвращает сервис по умолчанию для индексации
    """
    try:
        search_settings = settings.ISEARCH['searches']['base'][search]
        return search_settings['indexes'][index]['default_service']
    except KeyError:
        raise ImproperlyConfigured(
            'Cannot find default service for search "%s"."%s". Service must be specified.' %
            (search, index))
