from urllib.parse import urlparse, urlunparse

from django.conf import settings


def get_top_level_domain(url):
    hostname = urlparse(url).hostname
    for domain in settings.ISEARCH_AVAILABLE_TOP_LEVEL_DOMAINS:
        if hostname and hostname.endswith(domain):
            return domain

    raise RuntimeError(f'Url {url} not in available top level domains')


def change_domain(url, domain):
    """ Меняем домен в урле. Урл обязательно должен содержать схему (http / https)
    """
    url_domain = get_top_level_domain(url)
    if url_domain == domain:
        return url

    parsed_url = urlparse(url)
    subdomain = parsed_url.hostname.split(url_domain)[0].strip('.')
    new_netloc = f'{subdomain}.{domain}'
    if parsed_url.port:
        new_netloc = f'{new_netloc}:{parsed_url.port}'

    # list возвращает то же, что и вернул бы urlsplit. На первой позиции - netloc.
    # Более прямого метода замены я не нашел.
    url_list = list(parsed_url)
    url_list[1] = new_netloc
    return urlunparse(url_list)
